package expertSystemShell;

import unificationSolver.SimpleSentenceSolutionNode;
import unificationSolver.SubstitutionSet;


public class ESSimpleSentenceSolutionNode extends SimpleSentenceSolutionNode implements ESSolutionNode {

	private double certainty = 0.0;
	
	public ESSimpleSentenceSolutionNode(ESSimpleSentence goal, ESRuleSet rules,
			SubstitutionSet parentSolution) {
		super(goal, rules, parentSolution);
		nodesCreated++;
	}
	
	public synchronized SubstitutionSet nextSolution()  throws CloneNotSupportedException {
		SubstitutionSet solution = super.nextSolution();
		if(solution == null)
		{
			certainty = 0.0;
			return null;
		}
		
		ESRule rule = (ESRule) getCurrentRule();
		
		if(rule.ask())
		{
			ESFrontEnd frontEnd = ((ESRuleSet)getRuleSet()).getFrontEnd();
			certainty = frontEnd.ask((ESSimpleSentence)rule.getHead(), solution);
			
				return solution;
		}
		
		ESSolutionNode child = (ESSolutionNode) getChild();
		
		if(child == null)
		{                            
			certainty = rule.getCertaintyFactor();
		}
		else
		{
			certainty = child.getCertainty() * rule.getCertaintyFactor();
		}

			return solution;
	}
	
	public double getCertainty() {
		return certainty;
	}
}
